//   Temperature and humidity sensor


//Libraries
#include <DHT.h>;
#include <Adafruit_Sensor.h>

//Constants
#define DHTPIN_in D8     // Pin, sensor_in
#define DHTPIN_out D9     // Pin, sensor_out
#define DHTTYPE DHT22   // DHT 22  (AM2302)

DHT sensor_in(DHTPIN_in, DHTTYPE); //// Initialize DHT sensor for normal 16mhz Arduino
DHT sensor_out(DHTPIN_out, DHTTYPE); //// Initialize DHT sensor for normal 16mhz Arduino

//Variables
float hum_in;  //Stores humidity value
float temp_in; //Stores temperature value
float hum_out;  //Stores humidity value
float temp_out; //Stores temperature value

//Start
void setup(){
  Serial.begin(9600);
  sensor_in.begin();
  sensor_out.begin();
}


void loop(){
  
    delay(2000); //Delay 2 sec.
    
    //Read data and store it to variables hum and temp (sensor in)
    hum_in = sensor_in.readHumidity();
    temp_in = sensor_in.readTemperature();

    //Read data and store it to variables hum and temp (sensor out)
    hum_out = sensor_out.readHumidity();
    temp_out = sensor_out.readTemperature();
    

  if (isnan(hum_in) || isnan(temp_in)) {
    Serial.println("Failed to read from Sensor_in");
    return;
  } 

   if (isnan(hum_out) || isnan(temp_out)) {
    Serial.println("Failed to read from Sensor_out");
    return;
  }

    Serial.print("Temperature Inside: ");
    Serial.print(temp_in);
    Serial.print(" °C. Humidity Inside: ");
    Serial.print(hum_in);
    Serial.println(" %");

    Serial.print("Temperature Inside: ");
    Serial.println(temp_out);
    Serial.println(" °C. Humidity Inside: ");
    Serial.println(hum_out);
    Serial.println(" %");
  
}
